local t = Def.ActorFrame{};
local function IsW5Disabled() if PREFSMAN:GetPreference("TimingWindowSecondsW5") == 0 then return true else return false end end

local function IsClearedOrFailed(pn,i)
	local Song, StepsOrTrail
	local Profile = PROFILEMAN:GetProfile(pn)
	
	if GetCurrentSong() == nil then return nil else Song = GetCurrentSong() end
	if GetCurrentStepsOrTrail(pn) == nil then return nil else StepsOrTrail = GetCurrentStepsOrTrail(pn) end
	
	local ScoreList = Profile:GetHighScoreList(Song,StepsOrTrail)
	local Scores = ScoreList:GetHighScores()
	local TopScore = Scores[i]
	local Result
	
	if TopScore then
		if TopScore:GetGrade() == 'Grade_Failed' then
			Result = "FAILED"
		else
			Result = "CLEARED"
		end
	else
		Result = "NOT PLAYED"
	end
	return Result
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	local Player = ToEnumShortString(pn)
	for i = 1,5 do
		t[#t+1] = Def.ActorFrame{
			MisoBold()..{
				Name="TopScore"..i..Player;
				InitCommand=cmd(y,CenterY()+30+18*(IsW5Disabled() and 6 or 7);zoom,0.6;shadowlength,1);
				OnCommand=function(self) self:playcommand("Set") if pn == PLAYER_1 then self:x(Left()-11+52*i) else self:x(Right()-290-11+52*i) end end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
				SetCommand=function(self) self:diffuse(CustomDifficultyToColor(GetRawDifficulty(pn))):settext(string.gsub(GetSavedScore(pn,i) or string.format("%.2f",0)," ","")) end;
			};
		};
		t[#t+1] = Def.ActorFrame{
			MisoBold()..{
				Name="FailType"..Player;
				InitCommand=cmd(y,CenterY()+30+18*(IsW5Disabled() and 7 or 8);zoom,0.4;maxwidth,100;shadowlength,1);
				OnCommand=function(self) self:playcommand("Set") if pn == PLAYER_1 then self:x(Left()-11+52*i) else self:x(Right()-290-11+52*i) end end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
				SetCommand=function(self) self:diffuse(CustomDifficultyToColor(GetRawDifficulty(pn))):settext(IsClearedOrFailed(pn,i) or "N/A"):uppercase(true) end;
			};
		};
	end
end

return t